function scope_settings=load_scope_settings(config_fname)
% does config_fname exist? If not, load the one in the matlab paths
if ~isfile(config_fname)
    if exist(config_fname,'file')
        
        fprintf('%s is not provided, using default %s for processing.\n', config_fname, config_fname);
        config_fname=which(config_fname);

    else
        error([config_fname,' does not exist.']);
    end
else
    warning('%s is provided in the current folder, overriding default %s.\n',config_fname,config_fname);
end
   

txt=fileread(config_fname);
scope_settings=jsondecode(txt);

end

    


